/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource.components;

import java.awt.Component;
import java.beans.Beans;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import jclass.datasource.ColumnModel;
import jclass.datasource.DataModel;
import jclass.datasource.DataModelEvent;
import jclass.datasource.DataModelException;
import jclass.datasource.DataModelListener;
import jclass.datasource.DataSourceBeanInstance;
import jclass.datasource.DataTableModel;
import jclass.datasource.MetaDataModel;
import jclass.datasource.VirtualColumnModel;
import jclass.datasource.components.ExceptionManager;
import jclass.datasource.treemodel.TreeNodeModel;

public abstract class DataBinding
implements DataModelListener,
Serializable {
    public static final String PATH_DELIMITER = "|";
    public static final String SOURCE_DELIMITER = ":";
    protected DataModel dataModel;
    protected MetaDataModel metaDataModel;
    protected DataTableModel dataTableModel;
    protected boolean dataAvailable = false;
    protected Component component;
    protected String dataBinding;
    private static int DEBUG = -1;
    private static final boolean TRACE = false;

    public DataBinding(Component component) {
        this.component = component;
    }

    public DataBinding(Component component, DataModel dataModel, MetaDataModel metaDataModel) {
        this.component = component;
        this.setDataAvailable(this.dataAvailable);
        this.setDataBinding(dataModel, metaDataModel);
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        this.component = null;
        if (this.dataModel != null) {
            this.dataModel.removeDataModelListener(this);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public MetaDataModel getMetaDataModel() {
        return this.metaDataModel;
    }

    public DataTableModel getDataTableModel() {
        return this.dataTableModel;
    }

    public Object getNativeMetaData() {
        if (this.metaDataModel != null) {
            return this.metaDataModel.getNativeMetaData();
        }
        return null;
    }

    public String getDataBinding() {
        if (this.metaDataModel == null) {
            if (Beans.isDesignTime()) {
                if (this.dataBinding == null) {
                    return "";
                }
                return this.dataBinding;
            }
            return "";
        }
        String string = "";
        MetaDataModel metaDataModel = this.metaDataModel;
        while (metaDataModel != null) {
            string = String.valueOf(metaDataModel.getDescription()) + (string.length() == 0 ? "" : PATH_DELIMITER) + string;
            metaDataModel = (MetaDataModel)metaDataModel.getParent();
        }
        string = String.valueOf(this.dataModel.getModelName()) + SOURCE_DELIMITER + string;
        return string;
    }

    public void setDataBinding(DataModel dataModel, MetaDataModel metaDataModel) {
        this.setDataBindingInternalBegin(dataModel, metaDataModel);
        this.setDataBindingInternalEnd();
    }

    public void setDataBindingInternalBegin(DataModel dataModel, MetaDataModel metaDataModel) {
        if (this.dataModel != null) {
            this.dataModel.removeDataModelListener(this);
        }
        this.dataModel = dataModel;
        if (dataModel == null) {
            metaDataModel = null;
            return;
        }
        this.metaDataModel = metaDataModel == null ? (MetaDataModel)dataModel.getMetaDataTree().getRoot() : metaDataModel;
        this.dataTableModel = null;
        try {
            if (this.metaDataModel.getCommitPolicy() != 1) {
                this.metaDataModel.setShowDeletedRows(false);
                return;
            }
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
        }
    }

    public void setDataBindingInternalEnd() {
        if (this.dataModel == null) {
            return;
        }
        this.dataModel.addDataModelListener(this);
        this.checkDataTableChanged();
    }

    public void setDataBinding(DataModel dataModel, String string) {
        if (dataModel == null) {
            this.setDataBinding((DataModel)null, (MetaDataModel)null);
            return;
        }
        MetaDataModel metaDataModel = (MetaDataModel)dataModel.getMetaDataTree().getRoot();
        StringTokenizer stringTokenizer = new StringTokenizer(string, PATH_DELIMITER);
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            block0: while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                Enumeration enumeration = metaDataModel.getChildren().elements();
                while (enumeration.hasMoreElements()) {
                    MetaDataModel metaDataModel2 = (MetaDataModel)enumeration.nextElement();
                    if (string2.compareTo(metaDataModel2.getDescription()) != 0) continue;
                    metaDataModel = metaDataModel2;
                    continue block0;
                }
            }
        }
        this.setDataBinding(dataModel, metaDataModel);
    }

    public void setDataBinding(String string) {
        if (Beans.isDesignTime()) {
            this.dataBinding = string;
        }
        if (string == null || string.length() == 0) {
            this.setDataBinding((DataModel)null, (MetaDataModel)null);
            return;
        }
        int n = string.indexOf(SOURCE_DELIMITER);
        if (n == -1) {
            System.out.println("Invalid data binding hierarchy: \"" + string + "\"");
            return;
        }
        String string2 = string.substring(0, n);
        DataModel dataModel = null;
        Vector vector = DataSourceBeanInstance.getInstances();
        int n2 = 0;
        while (n2 < vector.size()) {
            dataModel = (DataModel)vector.elementAt(n2);
            if (dataModel != null && dataModel.getModelName() != null && string2.compareTo(dataModel.getModelName()) == 0) break;
            ++n2;
        }
        if (dataModel == null) {
            return;
        }
        this.setDataBinding(dataModel, string.substring(n + 1));
    }

    public int getNumRows() {
        try {
            return this.dataTableModel.getRowCount();
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return -1;
        }
    }

    public int getNumColumns() {
        try {
            return this.metaDataModel.getColumnCount();
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return -1;
        }
    }

    public void dataModelChanged(DataModelEvent dataModelEvent) {
        int n = dataModelEvent.getCommand();
        int n2 = dataModelEvent.getRowIndex();
        if (dataModelEvent.getTable().getMetaData() != this.metaDataModel) {
            switch (n) {
                default: {
                    return;
                }
                case 6: 
                case 10: 
                case 11: 
                case 103: 
                case 106: 
                case 109: 
            }
        }
        switch (n) {
            case 12: {
                if (!this.dataTableModel.tableIsAncestor(dataModelEvent.getTable()) || !dataModelEvent.isCancelable()) break;
                dataModelEvent.cancelProposedAction();
                return;
            }
            case 6: 
            case 10: 
            case 11: {
                if (this.beforeCurrentRowChange() || !dataModelEvent.isCancelable()) break;
                dataModelEvent.cancelProposedAction();
                return;
            }
            case 106: {
                this.checkDataTableChanged(dataModelEvent);
                return;
            }
            case 103: {
                this.debugMessage(3, this.getCommandString(n));
                if (!(dataModelEvent.getSource() instanceof DataModel)) break;
                this.dataModel.removeDataModelListener(this);
                this.dataModel = (DataModel)dataModelEvent.getSource();
                this.dataModel.addDataModelListener(this);
                this.checkDataTableChanged();
                return;
            }
            case 105: 
            case 107: 
            case 109: {
                this.debugMessage(3, this.getCommandString(n));
                this.checkDataTableChanged();
                return;
            }
            case 100: {
                String string = dataModelEvent.getColumn();
                if (string == null || string.length() == 0) {
                    this.rowDataChanged(n2);
                    return;
                }
                this.cellDataChanged(n2, string);
                return;
            }
            case 101: {
                this.rowInserted();
                return;
            }
            case 102: {
                this.rowDeleted();
                return;
            }
            case 108: {
                if (this != dataModelEvent.getOriginator()) break;
                this.moveToBestRowAfterDelete(dataModelEvent);
                return;
            }
        }
    }

    public void dataModelCreated(DataModelEvent dataModelEvent) {
    }

    protected abstract void tableChanged();

    protected abstract void rowDataChanged(int var1);

    protected abstract void cellDataChanged(int var1, String var2);

    protected abstract void currentRowChanged(int var1);

    protected abstract boolean beforeCurrentRowChange();

    protected abstract void rowInserted();

    protected abstract void rowDeleted();

    protected abstract void setDataAvailable(boolean var1);

    public boolean isDataAvailable() {
        return this.dataAvailable;
    }

    protected void checkDataTableChanged() {
        this.checkDataTableChanged(null, -1);
    }

    protected void checkDataTableChanged(DataModelEvent dataModelEvent) {
        this.checkDataTableChanged(dataModelEvent.getTable().getMetaData(), dataModelEvent.getRowIndex());
    }

    private void checkDataTableChanged(MetaDataModel metaDataModel, int n) {
        DataTableModel dataTableModel = null;
        try {
            dataTableModel = this.dataModel.getCurrentDataTable(this, this.metaDataModel);
            this.toggleDataAvailableState(dataTableModel != null);
            if (metaDataModel != this.metaDataModel || dataTableModel != this.dataTableModel) {
                this.dataTableModel = dataTableModel;
                this.tableChanged();
            }
            if (this.dataTableModel != null) {
                this.currentRowChanged(metaDataModel == this.metaDataModel ? n : this.getCurrentRowIndex());
                return;
            }
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
        }
    }

    protected void moveToBestRowAfterDelete(DataModelEvent dataModelEvent) {
        try {
            int n = dataModelEvent.getTable().getRowCount();
            int n2 = dataModelEvent.getRowIndex();
            if (n2 < n) {
                this.dataModel.moveToRow(this, dataModelEvent.getTable(), dataModelEvent.getTable().getRowIdentifier(n2));
                return;
            }
            if (n2 == n && n > 0) {
                this.dataModel.moveToRow(this, dataModelEvent.getTable(), dataModelEvent.getTable().getRowIdentifier(n2 - 1));
                return;
            }
            DataTableModel dataTableModel = (DataTableModel)((Object)((TreeNodeModel)((Object)dataModelEvent.getTable())).getParent());
            if (dataTableModel != null) {
                this.dataModel.moveToRow(this, dataTableModel, dataModelEvent.getTable().getParentBookmark());
                return;
            }
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
        }
    }

    protected int getCurrentRowIndex() {
        long l = this.metaDataModel.getCurrentBookmark();
        if (l >= 0L) {
            return this.dataTableModel.getRowIndex(l);
        }
        return -1;
    }

    protected boolean moveToRowIndex(int n) {
        try {
            return this.dataModel.moveToRow(this, this.dataTableModel, this.dataTableModel.getRowIdentifier(n));
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    protected void toggleDataAvailableState(boolean bl) {
        if (this.dataAvailable != bl) {
            this.dataAvailable = bl;
            this.setDataAvailable(this.dataAvailable);
        }
    }

    public boolean isColumnEditable(String string) {
        try {
            ColumnModel columnModel = this.metaDataModel.getColumnObject(string);
            return columnModel != null && !(columnModel instanceof VirtualColumnModel) && !columnModel.isReadOnly();
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            return false;
        }
    }

    private void debugMessage(int n, String string) {
        if (n <= DEBUG) {
            System.out.println(String.valueOf(("TABLE [" + this.metaDataModel.getDescription() + "]                     ").substring(0, 20)) + ": " + string);
        }
    }

    private String getCommandString(int n) {
        switch (n) {
            case 1: {
                return "BEFORE_INSERT_ROW";
            }
            case 2: {
                return "BEFORE_RESET";
            }
            case 3: {
                return "BEFORE_REQUERY";
            }
            case 4: {
                return "BEFORE_EDIT_CELL";
            }
            case 5: {
                return "BEFORE_DELETE_ROW";
            }
            case 6: {
                return "BEFORE_COMMIT_ALL";
            }
            case 7: {
                return "BEFORE_CANCEL_ALL";
            }
            case 8: {
                return "BEFORE_CANCEL_ROW_CHANGES";
            }
            case 9: {
                return "BEFORE_COMMIT_CONDITIONAL";
            }
            case 10: {
                return "BEFORE_COMMIT_ROW";
            }
            case 100: {
                return "AFTER_CHANGE_OF_ROW_DATA";
            }
            case 101: {
                return "AFTER_INSERT_ROW";
            }
            case 102: {
                return "AFTER_DELETE_ROW";
            }
            case 103: {
                return "AFTER_RESET";
            }
            case 104: {
                return "BEGIN_EVENTS";
            }
            case 105: {
                return "END_EVENTS";
            }
            case 11: {
                return "BEFORE_MOVE_TO_CURRENT_ROW";
            }
            case 106: {
                return "AFTER_MOVE_TO_CURRENT_ROW";
            }
            case 107: {
                return "INITIALIZE";
            }
            case 109: {
                return "AFTER_REQUERY_ROW_AND_DETAILS";
            }
        }
        return "";
    }
}

